clc, clear
LibO = myOutputFile;
LibI = myInterfacciaDAQ;
LibT = myTdmsReader;
Zero = [2.872748438 -0.088105225];

%%
% REAR
% d/L = 50% n600: (37) (77) (87)
% d/L = 50% n800: (39) (79) (89)

% FRONT
% d/L =-50% n600: (47) (67) (57)
% d/L =-50% n600: (49) (69) (59)

%%
nVet = 500:100:900;
CDalone = [0.3144	0.3810	0.4292	0.4654	0.4941]; 

dCDfront = [0.25	0.0202	-0.0083	-0.014	-0.0303	-0.0296
            0.5	-0.0105	-0.0454	-0.0657	-0.0792	-0.0924
            0.75	0.0017	-0.0324	-0.044	-0.0516	-0.0646
            1.0	0.0177	-0.0019	-0.0105	-0.0221	-0.029
            1.5	0.0387	0.0165	0.0087	0.0058	0.0042
            2.0	0.052	0.0378	0.0266	0.0196	0.015
            3.0	0.0155	0.009	0.0079	0.0049	0.0026
            4.0	0.0165	0.0101	0.0032	0.002	0.0011
            5.0	0.0147	0.0055	0.0055	0	-0.0008
            6.0	0.012	0.0059	0.0026	-0.0002	-0.0018
            7.0	0.0088	0.0026	0.0018	-0.0022	-0.003
            9.27	0.0063	-0.0024	-0.0029	-0.0053	-0.0056];
dCDfront(:,1) = -dCDfront(:,1);

dCDrear = [0 zeros(1,5)
        0.25	-0.1529	-0.1827	-0.2007	-0.2144	-0.2194
        0.5	-0.1423	-0.1744	-0.1945	-0.2076	-0.2159
        0.75	-0.0833	-0.1027	-0.1246	-0.144	-0.1627
        1.0	-0.0887	-0.1103	-0.1426	-0.1563	-0.1643
        1.5	-0.1122	-0.1334	-0.1466	-0.1555	-0.164
        2.0	-0.1008	-0.1248	-0.1375	-0.1458	-0.1564
        3.0	-0.0951	-0.1131	-0.122	-0.1315	-0.1349
        3.5	-0.0602	-0.0858	-0.0998	-0.1131	-0.1219
        4.15	-0.0504	-0.0746	-0.0896	-0.1031	-0.114];

dCD = [flipud(dCDfront); dCDrear];
interpPlatoon = @(n,d) CDalone(nVet==n)+[0 dCD(dCD(:,1)==d,[nan nVet]==n)];

%%
ss = cell(3,1);
for K = 1:3
 ss{K} = LibO.txt2struct([],[],"Scegli file n°"+K);
end

%%
leggi = @(s) str2num(replace(regexp(s,'(\-)?[\d\.]{2,}(%)?','match')+"",'%','/100')); %#ok<*ST2NM>
f = figure('Color','w');


for K=1:3
s = ss{K};
[slc, tlc, ~] = LibO.extractFromFile( s.loa );
[smi, tmi, ~] = LibO.extractFromFile( s.mics );
[sge, tge, tags] = LibO.extractFromFile( s.get );


nor = @(m) rescale(m,'InputMin',5.5,'InputMax',9.5);
mm = [6,9,16]; %<<-- i numeri dei microfoni delle sonde scelte.

micMode = 1;    %(0)timeline, (1)frequency
filterMic = 1;  %(0) no filter, (1) yes filter

if filterMic
    windowCoeff = load('secondo_grup.mat').G2;
    windowCoeff(:,1:8) = load('primo_grup.mat').G1;
    smi = smi - mean(smi);
    for i=1:size(smi,2)
        smi(:,i) = filter( windowCoeff(:,i),1, smi(:,i) ) * 10; 
    end
end

%% condizioni
subplot(3,6,1)
    note = importdata(s.note,'s');
    if K==1
        note{3} = replace(note{3},'Elica','Propeller');
        Uinf = leggi(note{end-2});
        Rey  = Uinf*1.225*0.17/1.5;
        appunti = [note([3 5 6]); {sprintf('Re = %.3f x 10^5',Rey)}];
        text(0.5,0,appunti,'hor','center','ver','top'), hold on,
       
        ax=gca; %ax.XColor = 'none'; ax.YColor='none';

        n = leggi(note{3});
        dL= leggi(note{5});
        if dL >0
            title('Rear Platooning')
        else
            title('Front Platooning')
        end
        default = interpPlatoon(n,dL);
        CDsingle = default(1);
        CDplatoon = default(2);

    end
    CD0 = leggi(note{4});
    CDf = leggi(note{end});
    delta = CDf-CD0; 

%% valori dei cd    
subplot(3,6,1+[6 12])
    if K==1
       bar(0,CDsingle,'BaseValue',CDplatoon); hold on
       title('Performance Overview')
       ylabel('CD coeffients')
       stringa = {sprintf('CD_{ISOLATED}: %.3g',CDsingle); '';
                  ['\DeltaCD_{PLATOON}: ' sprintf('%.3g',CDplatoon-CDsingle)]; 
                  sprintf('(%2.1f)%%',100*(CDplatoon-CDsingle)/CDsingle)};
       text(2, CDsingle,stringa,'hor','center','ver','top','fontsize',9);
       xticks(1:3)
       xticklabels(["costant" "sine" "double sine"]);
       xtickangle(45)
       xlabel('forcing methods')
       stringa={sprintf('CD_{PLATOON}: %.3g',CDplatoon);'reference condition'};
       text(2, CDplatoon,stringa,'hor','center','ver','bot','fontsize',9);
       ylim([0.1 0.5])
    end
    
    bb(K)=bar(K,CDplatoon+delta,'BaseValue',CDplatoon); %#ok<SAGROW>
    plot( 0,CDplatoon+delta,'>','Color',bb(K).FaceColor);
    stringa = {'\DeltaCD'; sprintf('%.3g',delta); sprintf('(%2.1f)%%',100*delta/CDplatoon)};
    text(K, CDplatoon+delta, stringa,'hor','center','Ver','top','fontsize',7);

    if K==3
    ax=gca;
    ax.Position(1) = ax.Position(1)*0.25;
    ax.Position(3) = ax.Position(3)*1.7;
    end
    
%% asse Load Cell e control Signal e CD
subplot(3,6,(K-1)*6+[2 3])
    gee(1:3)=plot(tge, nor(sge(1:length(tge),:)),'-'); hold on,
    aa=gca; aa.YLabel.BackgroundColor=bb(K).FaceColor;
    
    % xlim(tge([1 end]))
    % plot(tlc,slc(:,1),'-')
    set(gca,'Tag','uno')
    
    text(25, 0.1,'[Unforced Phase]  ','hor','right');
    text(25, 0.1,'  [Forced Phase]','hor','left');
    
    out = LibT.computeCd( slc(:,[1 4]), [], Zero);
    CDpre  = mean(out.Cd(tlc<=25));
    CDpost = mean(out.Cd(tlc> 25));
    gee(4)=plot(tlc,out.Cd,':');
    gee(5)=plot([0 25*[1 1] tlc(end)],[CDpre CDpre CDpost CDpost],'--k');
    
    text(24, 0.6,{'\DeltaCD: '; string(round(CDpost-CDpre,3))},'hor','center');
    quiver(24.2,0.6,0.78,CDpre+0.01-0.6,0,'Color','red');
    
    ll = legend(gee,'VariableNames',["[%] Top" "[%] Bot",...
           "[%] Side" "CD_{ISTANTANEOUS}" "CD_{MEAN}"]); 
    ll.ItemHitFcn = @myTdmsReader.ShowOnOff;
    xlim([23 27])
    
    
    if K==1, title('Jet Signal and Drag'), end
    ylabel({'Costant';'Control Signal'})
    
    
    subplot(3,6,6+[2 3]) % 2ax LC
    ylabel({'Sinusoidal';'Control Signal'})
    
    subplot(3,6,12+[2 3]) % 3ax LC
    ylabel({'Double Sinusoid';'Control Signal'})
    
    
    if K==3, xlabel('time [s]'), end
  
%% asse microfoni (PSD/timeline)    
subplot(3,6,(K-1)*6+[4 5])
    switch filterMic
        case 1; extra = " filtered"; 
        case 0; extra = "";
    end
    
    colori = 'rgc';
    
    if micMode == 0   
    plot(tmi,smi(:,mm),':'), hold on
    plot(tmi,rms(smi(:,mm),2),'-k'), hold on, 

    if filterMic, ylabel('P_{sound} [Pa]'), end
    xlim(tmi([1 end]))
    title('Microphones Signal'+extra)

    ll = legend('VariableNames',["Top" "Side" "Bot" "RMS_{TOT}"]);
    ll.ItemHitFcn = @myTdmsReader.ShowOnOff;
    ll.Title.String = 'Time Domain';
     if K==3, ylabel('time [s]'), end
    set(gca,'Tag','due')
    else
        
     
    [Pxrest  ,f1]=pwelch(smi(tmi<25,mm), [],[],[],sum(tmi<1));
    [Pxforced,f2]=pwelch(smi(tmi>26,mm), [],[],[],sum(tmi<1));
    forzati=loglog(f2,Pxforced,'-'); hold on
    naturali=loglog(f1,Pxrest,':');
    
    for i=1:3
        forzati(i).Color=colori(i);
       naturali(i).Color=colori(i);
    end
    if K==1, title('Microphones'+extra+' Signal - PSD'), end
    xlim(10.^[-1 1.5])
    ll = legend('VariableNames',["Top" "Side" "Bot",...
           "unforced"+["" "" ""]]); %_"+["{TOP}" "{SIDE}" "{BOT}"]
    ll.ItemHitFcn = @myTdmsReader.ShowOnOff;
    ll.NumColumns = 2;
    ll.Title.String = 'Frequency Domain';
    if K==3, xlabel('f [Hz]'), end
    set(gca,'Tag','due')
    end
    
%% cross correlation coefficients
subplot(3,6, K*6)
    cut = @(x,t) x(t>25+1);
    Mtop = cut( smi(:,mm(1)), tmi);
    Msid = cut( smi(:,mm(2)), tmi);
    Mbot = cut( smi(:,mm(3)), tmi);


    [M(1,1),delay(1,1),~]=crossCor(Mtop,Mtop,tmi);
    [M(1,2),delay(1,2),~]=crossCor(Mtop,Msid,tmi);
    [M(1,3),delay(1,3),~]=crossCor(Mtop,Mbot,tmi);

    [M(2,1),delay(2,1),~]=crossCor(Msid,Mtop,tmi);
    [M(2,2),delay(2,2),~]=crossCor(Msid,Msid,tmi);
    [M(2,3),delay(2,3),~]=crossCor(Msid,Mbot,tmi);

    [M(3,1),delay(3,1),~]=crossCor(Mbot,Mtop,tmi);
    [M(3,2),delay(3,2),~]=crossCor(Mbot,Msid,tmi);
    [M(3,3),delay(3,3),~]=crossCor(Mbot,Mbot,tmi);
    
    
    imagesc(M([2 3 6])'); hold on
    colormap('jet'); 
    cc=colorbar; caxis([0 1]);
    
    yticklabels( {'TOP vs SIDE','TOP vs BOT', 'SIDE vs BOT'})
    for i=1:3
        pp=[2 3 6];
        text( 1,i,sprintf('%1.3g\n@ delay of\n%1.2f [s]',M(pp(i)),delay(pp(i))),...
            'Color','w','hor','center','fontsize',8)
    end
    xticks([])
    if K==1, title({'Cross Correlation'; 'Coefficients'}),end

end

f=gcf;
linkaxes(findobj('Tag','uno'),'x')
linkaxes(findobj('Tag','due'),'x')

subplot(3,6,1)
[img] = imread('truckIcon.png');
img=double(img);
img(~img)=nan;  %<- messa in trasparenza (i valori nulli diventano Nan).

            
%parametri per il display del furgoncino.(dimensioni e griglia)
rap = size(img,1)/size(img,2);   
L=1;
xg = linspace(0,    L,size(img,2));
yg = linspace(L*rap,0,size(img,1));


if dL >0
    ii=[-1 1];
else
    ii=[1 -1];
end

% disegno i furgoncini, 2 fantocci (blu) e 1 arancio (con spie)
PL.truck{1} = surf(xg+ii(1),yg,img*0,cat(3,img*0,img*0.5,img*1),'EdgeColor','none');
%PL.truck{2} = surf(xg+8-L/2,yg-1.5,img*0,cat(3,img*0,img*0.5,img*1),'EdgeColor','none');
          hold on  
% icona furgone arancio (quello con le spie).
img(1:10,140:180)=1;
PL.truck{3} = surf(xg+ii(2),yg,img*0,cat(3,img,img*0.5,img*0.1),'EdgeColor','none');
            
% linea di collegamento tra i furgoni.
PL.truck{4} = plot([0 1],0.1*[1 1],'-k','Marker','o',...
                'MarkerIndices',[1 2],'MarkerFaceColor','b');
ax=gca;
ax.XColor='none'; ax.YColor='none';
ax.DataAspectRatio=[1 1 1];
axis auto

f.WindowState='maximized';
f.Children(end).Position([1 3])=f.Children(end-1).Position([1 3]);

function [A,delay,a]=crossCor(s1,s2,tmi)
maxDel = round(8 /(tmi(2)-tmi(1)));
[a,b] = xcorr(s1, s2, maxDel,'coef');
[A,i]=max(a); delay = b(i)*(tmi(2)-tmi(1));
end

